/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity;

import com.lycanitesmobs.Utilities;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.entity.EntityProjectileBase;
import com.lycanitesmobs.core.entity.EntityProjectileLaserEnd;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityProjectileLaser
extends EntityProjectileBase {
    public EntityLivingBase shootingEntity;
    public Entity followEntity;
    public int shootingEntityRef = -1;
    public int shootingEntityID = 11;
    public float projectileWidth = 0.2f;
    public float projectileHeight = 0.2f;
    public EntityProjectileLaserEnd laserEnd;
    public int laserEndRef = -1;
    public int laserEndID = 12;
    public int laserTime = 100;
    public int laserDelay = 20;
    public float laserRange;
    public float laserWidth;
    public float laserLength = 10.0f;
    public int laserTimeID = 13;
    public boolean useEntityAttackTarget = true;
    private double targetX;
    private double targetY;
    private double targetZ;
    public double offsetX = 0.0;
    public double offsetY = 0.0;
    public double offsetZ = 0.0;
    public int offsetIDStart = 14;
    protected static final DataParameter<Integer> SHOOTING_ENTITY_ID = EntityDataManager.func_187226_a(EntityProjectileLaser.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> LASER_END_ID = EntityDataManager.func_187226_a(EntityProjectileLaser.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> LASER_TIME = EntityDataManager.func_187226_a(EntityProjectileLaser.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Float> OFFSET_X = EntityDataManager.func_187226_a(EntityProjectileLaser.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Float> OFFSET_Y = EntityDataManager.func_187226_a(EntityProjectileLaser.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Float> OFFSET_Z = EntityDataManager.func_187226_a(EntityProjectileLaser.class, (DataSerializer)DataSerializers.field_187193_c);

    public EntityProjectileLaser(World world) {
        super(world);
        this.setStats();
        this.setTime(0);
    }

    public EntityProjectileLaser(World world, double par2, double par4, double par6, int setTime, int setDelay) {
        super(world, par2, par4, par6);
        this.laserTime = setTime;
        this.laserDelay = setDelay;
        this.setStats();
    }

    public EntityProjectileLaser(World world, double par2, double par4, double par6, int setTime, int setDelay, Entity followEntity) {
        this(world, par2, par4, par6, setTime, setDelay);
        this.followEntity = followEntity;
    }

    public EntityProjectileLaser(World world, EntityLivingBase par2EntityLivingBase, int setTime, int setDelay) {
        this(world, par2EntityLivingBase, setTime, setDelay, null);
    }

    public EntityProjectileLaser(World world, EntityLivingBase entityLiving, int setTime, int setDelay, Entity followEntity) {
        super(world, entityLiving);
        this.shootingEntity = entityLiving;
        this.laserTime = setTime;
        this.laserDelay = setDelay;
        this.setStats();
        this.followEntity = followEntity;
        this.syncOffset();
    }

    public void setStats() {
        this.func_70105_a(this.projectileWidth, this.projectileHeight);
        this.setRange(16.0f);
        this.setLaserWidth(1.0f);
        this.knockbackChance = 0.0;
        this.targetX = this.field_70165_t;
        this.targetY = this.field_70163_u;
        this.targetZ = this.field_70161_v;
        this.field_70180_af.func_187214_a(SHOOTING_ENTITY_ID, (Object)this.shootingEntityRef);
        this.field_70180_af.func_187214_a(LASER_END_ID, (Object)this.laserEndRef);
        this.field_70180_af.func_187214_a(LASER_TIME, (Object)this.laserTime);
        this.field_70180_af.func_187214_a(OFFSET_X, (Object)Float.valueOf((float)this.offsetX));
        this.field_70180_af.func_187214_a(OFFSET_Y, (Object)Float.valueOf((float)this.offsetY));
        this.field_70180_af.func_187214_a(OFFSET_Z, (Object)Float.valueOf((float)this.offsetZ));
        this.field_70145_X = true;
    }

    public AxisAlignedBB func_184177_bl() {
        if (this.laserEnd == null) {
            return super.func_184177_bl();
        }
        double distance = this.func_70032_d((Entity)this.laserEnd);
        return super.func_184177_bl().func_72314_b(distance, distance, distance);
    }

    public void setOffset(double x, double y, double z) {
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
        this.syncOffset();
    }

    @Override
    public void func_70071_h_() {
        if (!this.func_130014_f_().field_72995_K) {
            this.field_70180_af.func_187227_b(LASER_TIME, (Object)this.laserTime);
        } else {
            this.laserTime = (Integer)this.field_70180_af.func_187225_a(LASER_TIME);
        }
        this.syncShootingEntity();
        if (!this.func_130014_f_().field_72995_K && this.shootingEntity != null) {
            EntityLivingBase entityToFollow = this.shootingEntity;
            if (this.followEntity != null) {
                entityToFollow = this.followEntity;
            }
            double xPos = entityToFollow.field_70165_t + this.offsetX;
            double yPos = entityToFollow.field_70163_u - (double)(this.field_70131_O / 2.0f) + this.offsetY;
            double zPos = entityToFollow.field_70161_v + this.offsetZ;
            if (entityToFollow instanceof EntityCreatureBase) {
                EntityCreatureBase creatureToFollow = (EntityCreatureBase)entityToFollow;
                xPos = creatureToFollow.getFacingPosition((Entity)creatureToFollow, this.offsetX, creatureToFollow.field_70177_z + 90.0f).func_177958_n();
                zPos = creatureToFollow.getFacingPosition((Entity)creatureToFollow, this.offsetZ, creatureToFollow.field_70177_z).func_177952_p();
            }
            this.func_70107_b(xPos, yPos, zPos);
        }
        if (this.laserTime > 0) {
            this.updateEnd();
            --this.laserTime;
            double minX = 0.0;
            double maxX = 0.0;
            double minY = 0.0;
            double maxY = 0.0;
            double minZ = 0.0;
            double maxZ = 0.0;
            if (this.laserEnd != null) {
                minX = this.field_70165_t - (double)this.field_70130_N < this.laserEnd.field_70165_t - (double)this.laserEnd.field_70130_N ? this.field_70165_t - (double)this.field_70130_N : this.laserEnd.field_70165_t - (double)this.laserEnd.field_70130_N;
                maxX = this.field_70165_t + (double)this.field_70130_N > this.laserEnd.field_70165_t + (double)this.laserEnd.field_70130_N ? this.field_70165_t + (double)this.field_70130_N : this.laserEnd.field_70165_t + (double)this.laserEnd.field_70130_N;
                minY = this.field_70163_u - (double)this.field_70131_O < this.laserEnd.field_70163_u - (double)this.laserEnd.field_70131_O ? this.field_70163_u - (double)this.field_70131_O : this.laserEnd.field_70163_u - (double)this.laserEnd.field_70131_O;
                maxY = this.field_70163_u + (double)this.field_70130_N > this.laserEnd.field_70163_u + (double)this.laserEnd.field_70131_O ? this.field_70163_u + (double)this.field_70131_O : this.laserEnd.field_70163_u + (double)this.laserEnd.field_70131_O;
                minZ = this.field_70161_v - (double)this.field_70130_N < this.laserEnd.field_70161_v - (double)this.laserEnd.field_70130_N ? this.field_70161_v - (double)this.field_70130_N : this.laserEnd.field_70161_v - (double)this.laserEnd.field_70130_N;
                maxZ = this.field_70161_v + (double)this.field_70130_N > this.laserEnd.field_70161_v + (double)this.laserEnd.field_70130_N ? this.field_70161_v + (double)this.field_70130_N : this.laserEnd.field_70161_v + (double)this.laserEnd.field_70130_N;
            } else {
                minX = this.field_70165_t - (double)this.field_70130_N;
                maxX = this.field_70165_t + (double)this.field_70130_N;
                minY = this.field_70163_u - (double)this.field_70131_O;
                maxY = this.field_70163_u + (double)this.field_70131_O;
                minZ = this.field_70161_v - (double)this.field_70130_N;
                maxZ = this.field_70161_v + (double)this.field_70130_N;
            }
            this.func_174813_aQ().func_72314_b(maxX - minX - (this.func_174813_aQ().field_72336_d - this.func_174813_aQ().field_72340_a), maxY - minY - (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b), maxZ - minZ - (this.func_174813_aQ().field_72334_f - this.func_174813_aQ().field_72339_c));
        } else if (!this.field_70128_L) {
            this.func_70106_y();
        }
    }

    public void updateEnd() {
        if (this.func_130014_f_().field_72995_K) {
            this.laserEndRef = (Integer)this.field_70180_af.func_187225_a(LASER_END_ID);
            Entity possibleLaserEnd = null;
            if (this.laserEndRef != -1) {
                possibleLaserEnd = this.func_130014_f_().func_73045_a(this.laserEndRef);
            }
            if (possibleLaserEnd != null && possibleLaserEnd instanceof EntityProjectileLaserEnd) {
                this.laserEnd = (EntityProjectileLaserEnd)possibleLaserEnd;
            } else {
                this.laserEnd = null;
                return;
            }
        }
        if (this.laserEnd == null) {
            this.fireProjectile();
        }
        if (this.laserEnd == null) {
            this.laserEndRef = -1;
        } else {
            if (!this.func_130014_f_().field_72995_K) {
                this.laserEndRef = this.laserEnd.func_145782_y();
            }
            boolean lockedLaser = false;
            if (this.shootingEntity != null && this.useEntityAttackTarget) {
                if (this.shootingEntity instanceof EntityCreatureBase && ((EntityCreatureBase)this.shootingEntity).func_70638_az() != null) {
                    EntityLivingBase attackTarget = ((EntityCreatureBase)this.shootingEntity).func_70638_az();
                    this.targetX = attackTarget.field_70165_t;
                    this.targetY = attackTarget.field_70163_u + (double)(attackTarget.field_70131_O / 2.0f);
                    this.targetZ = attackTarget.field_70161_v;
                    lockedLaser = true;
                } else {
                    Vec3d lookDirection = this.shootingEntity.func_70040_Z();
                    this.targetX = this.shootingEntity.field_70165_t + lookDirection.field_72450_a * (double)this.laserRange;
                    this.targetY = this.shootingEntity.field_70163_u + (double)this.shootingEntity.func_70047_e() + lookDirection.field_72448_b * (double)this.laserRange;
                    this.targetZ = this.shootingEntity.field_70161_v + lookDirection.field_72449_c * (double)this.laserRange;
                }
            }
            HashSet<Entity> excludedEntities = new HashSet<Entity>();
            excludedEntities.add((Entity)this);
            if (this.shootingEntity != null) {
                excludedEntities.add((Entity)this.shootingEntity);
            }
            if (this.followEntity != null) {
                excludedEntities.add(this.followEntity);
            }
            RayTraceResult target = Utilities.raytrace(this.func_130014_f_(), this.field_70165_t, this.field_70163_u, this.field_70161_v, this.targetX, this.targetY, this.targetZ, this.laserWidth, excludedEntities);
            double newTargetX = this.targetX;
            double newTargetY = this.targetY;
            double newTargetZ = this.targetZ;
            if (target != null && target.field_72307_f != null && !lockedLaser) {
                newTargetX = target.field_72307_f.field_72450_a;
                newTargetY = target.field_72307_f.field_72448_b;
                newTargetZ = target.field_72307_f.field_72449_c;
            }
            this.laserEnd.onUpdateEnd(newTargetX, newTargetY, newTargetZ);
            if (this.laserTime % this.laserDelay == 0 && this.func_70089_S() && target != null && target.field_72308_g != null && this.laserEnd.func_70032_d(target.field_72308_g) <= this.laserWidth * 10.0f) {
                boolean doDamage = true;
                if (target.field_72308_g instanceof EntityLivingBase) {
                    doDamage = this.canDamage((EntityLivingBase)target.field_72308_g);
                }
                if (doDamage) {
                    this.updateDamage(target.field_72308_g);
                }
            }
        }
        this.field_70180_af.func_187227_b(LASER_END_ID, (Object)this.laserEndRef);
        if (this.getBeamSound() != null) {
            this.func_184185_a(this.getBeamSound(), 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        }
    }

    public void setTime(int time) {
        this.laserTime = time;
    }

    public int getTime() {
        return this.laserTime;
    }

    public void fireProjectile() {
        World world = this.func_130014_f_();
        if (world.field_72995_K) {
            return;
        }
        try {
            if (this.shootingEntity == null) {
                Constructor constructor = this.getLaserEndClass().getDeclaredConstructor(World.class, Double.TYPE, Double.TYPE, Double.TYPE, EntityProjectileLaser.class);
                constructor.setAccessible(true);
                this.laserEnd = (EntityProjectileLaserEnd)((Object)constructor.newInstance(new Object[]{world, this.field_70165_t, this.field_70163_u, this.field_70161_v, this}));
            } else {
                Constructor constructor = this.getLaserEndClass().getDeclaredConstructor(World.class, EntityLivingBase.class, EntityProjectileLaser.class);
                constructor.setAccessible(true);
                this.laserEnd = (EntityProjectileLaserEnd)((Object)constructor.newInstance(new Object[]{world, this.shootingEntity, this}));
            }
            if (this.getLaunchSound() != null) {
                this.func_184185_a(this.getLaunchSound(), 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
            }
            world.func_72838_d((Entity)this.laserEnd);
        }
        catch (Exception e) {
            System.out.println("[WARNING] [LycanitesMobs] EntityLaser was unable to instantiate the EntityLaserEnd.");
            e.printStackTrace();
        }
    }

    public void syncShootingEntity() {
        if (!this.func_130014_f_().field_72995_K) {
            this.shootingEntityRef = this.shootingEntity == null ? -1 : this.shootingEntity.func_145782_y();
            this.field_70180_af.func_187227_b(SHOOTING_ENTITY_ID, (Object)this.shootingEntityRef);
        } else {
            Entity possibleShootingEntity;
            this.shootingEntityRef = (Integer)this.field_70180_af.func_187225_a(SHOOTING_ENTITY_ID);
            this.shootingEntity = this.shootingEntityRef == -1 ? null : ((possibleShootingEntity = this.func_130014_f_().func_73045_a(this.shootingEntityRef)) != null && possibleShootingEntity instanceof EntityLivingBase ? (EntityLivingBase)possibleShootingEntity : null);
        }
    }

    public void syncOffset() {
        if (!this.func_130014_f_().field_72995_K) {
            this.field_70180_af.func_187227_b(OFFSET_X, (Object)Float.valueOf((float)this.offsetX));
            this.field_70180_af.func_187227_b(OFFSET_Y, (Object)Float.valueOf((float)this.offsetY));
            this.field_70180_af.func_187227_b(OFFSET_Z, (Object)Float.valueOf((float)this.offsetZ));
        } else {
            this.offsetX = ((Float)this.field_70180_af.func_187225_a(OFFSET_X)).floatValue();
            this.offsetY = ((Float)this.field_70180_af.func_187225_a(OFFSET_Y)).floatValue();
            this.offsetZ = ((Float)this.field_70180_af.func_187225_a(OFFSET_Z)).floatValue();
        }
    }

    public EntityProjectileLaserEnd getLaserEnd() {
        return this.laserEnd;
    }

    public Class getLaserEndClass() {
        return EntityProjectileLaserEnd.class;
    }

    public void setTarget(double x, double y, double z) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
    }

    @Override
    protected float func_70185_h() {
        return 0.0f;
    }

    @Override
    protected void func_70184_a(RayTraceResult rayTraceResult) {
    }

    public boolean updateDamage(Entity target) {
        float damage;
        boolean attackSuccess = false;
        float damageInit = damage = this.getDamage(target);
        double pierceValue = 5.0;
        if (this.func_85052_h() instanceof EntityCreatureBase) {
            pierceValue = ((EntityCreatureBase)this.func_85052_h()).getPierceValue();
        }
        float pierceDamage = 1.0f + (float)Math.floor((double)damage / pierceValue);
        double targetKnockbackResistance = 0.0;
        if (this.knockbackChance < 1.0 && (this.knockbackChance <= 0.0 || this.field_70146_Z.nextDouble() <= this.knockbackChance) && target instanceof EntityLivingBase) {
            targetKnockbackResistance = ((EntityLivingBase)target).func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e();
            ((EntityLivingBase)target).func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        }
        if (this.func_85052_h() instanceof EntityCreatureBase) {
            EntityCreatureBase creatureThrower = (EntityCreatureBase)this.func_85052_h();
            if (damage <= pierceDamage) {
                attackSuccess = target.func_70097_a(creatureThrower.getDamageSource((EntityDamageSource)DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()).func_76348_h()).func_151518_m(), damage);
            } else {
                int hurtResistantTimeBefore = target.field_70172_ad;
                target.func_70097_a(creatureThrower.getDamageSource((EntityDamageSource)DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()).func_76348_h()).func_151518_m(), pierceDamage);
                target.field_70172_ad = hurtResistantTimeBefore;
                attackSuccess = target.func_70097_a(creatureThrower.getDamageSource((EntityDamageSource)DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h())), damage -= pierceDamage);
            }
        } else if (damage <= pierceDamage) {
            attackSuccess = target.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()).func_76348_h().func_151518_m(), damage);
        } else {
            int hurtResistantTimeBefore = target.field_70172_ad;
            target.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()).func_76348_h().func_151518_m(), pierceDamage);
            target.field_70172_ad = hurtResistantTimeBefore;
            attackSuccess = target.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), damage -= pierceDamage);
        }
        if (target instanceof EntityLivingBase) {
            this.onDamage((EntityLivingBase)target, damageInit, attackSuccess);
        }
        if (this.knockbackChance < 1.0 && (this.knockbackChance <= 0.0 || this.field_70146_Z.nextDouble() <= this.knockbackChance) && target instanceof EntityLivingBase) {
            ((EntityLivingBase)target).func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(targetKnockbackResistance);
        }
        return attackSuccess;
    }

    public void setRange(float range) {
        this.laserRange = range;
    }

    public void setLaserWidth(float width) {
        this.laserWidth = width;
    }

    public float getLaserWidth() {
        return this.laserWidth;
    }

    public float getLaserAlpha() {
        return 0.25f + (float)((double)0.1f * Math.sin(this.field_70173_aa));
    }

    public ResourceLocation getBeamTexture() {
        return null;
    }

    public double[] getLengths() {
        if (this.laserEnd == null) {
            return new double[]{0.0, 0.0, 0.0};
        }
        return new double[]{this.laserEnd.field_70165_t - this.field_70165_t, this.laserEnd.field_70163_u - this.field_70163_u, this.laserEnd.field_70161_v - this.field_70161_v};
    }

    public float getLength() {
        if (this.laserEnd == null) {
            return 0.0f;
        }
        return this.func_70032_d((Entity)this.laserEnd);
    }

    public float[] getBeamAngles() {
        float[] angles = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        if (this.laserEnd != null) {
            float dx = (float)(this.laserEnd.field_70165_t - this.field_70165_t);
            float dy = (float)(this.laserEnd.field_70163_u - this.field_70163_u);
            float dz = (float)(this.laserEnd.field_70161_v - this.field_70161_v);
            angles[0] = (float)Math.toDegrees(Math.atan2(dz, dy)) - 90.0f;
            angles[1] = (float)Math.toDegrees(Math.atan2(dx, dz));
            angles[2] = (float)Math.toDegrees(Math.atan2(dx, dy)) - 90.0f;
            float dr = (float)Math.sqrt(dx * dx + dz * dz);
            angles[3] = (float)Math.toDegrees(Math.atan2(dr, dy)) - 90.0f;
        }
        return angles;
    }

    @Override
    public SoundEvent getLaunchSound() {
        return null;
    }

    public SoundEvent getBeamSound() {
        return null;
    }

    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound.func_74764_b("LaserTime")) {
            this.setTime(nbtTagCompound.func_74762_e("LaserTime"));
        }
        if (nbtTagCompound.func_74764_b("OffsetX")) {
            this.offsetX = nbtTagCompound.func_74769_h("OffsetX");
        }
        if (nbtTagCompound.func_74764_b("OffsetY")) {
            this.offsetY = nbtTagCompound.func_74769_h("OffsetY");
        }
        if (nbtTagCompound.func_74764_b("OffsetZ")) {
            this.offsetZ = nbtTagCompound.func_74769_h("OffsetZ");
        }
        super.func_70037_a(nbtTagCompound);
    }

    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74768_a("LaserTime", this.laserTime);
        nbtTagCompound.func_74780_a("OffsetX", this.offsetX);
        nbtTagCompound.func_74780_a("OffsetY", this.offsetY);
        nbtTagCompound.func_74780_a("OffsetZ", this.offsetZ);
        super.func_70014_b(nbtTagCompound);
    }
}

